<?php

///////////////////////////////////////
// sanitize.inc.php
// Sanitization functions for PHP
// by: Gavin Zuchlinski, Jamie Pratt, Hokkaido
// webpage: http://libox.net
// Last modified: September 27, 2003
//
// Many thanks to those on the webappsec list for helping me improve these functions
///////////////////////////////////////
// Function list:
// sanitize_paranoid_string($string) -- input string, returns string stripped of all non 
//           alphanumeric
// sanitize_system_string($string) -- input string, returns string stripped of special
//           characters
// sanitize_sql_string($string) -- input string, returns string with slashed out quotes
// sanitize_html_string($string) -- input string, returns string with html replacements
//           for special characters
// sanitize_int($integer) -- input integer, returns ONLY the integer (no extraneous 
//           characters
// sanitize_float($float) -- input float, returns ONLY the float (no extraneous 
//           characters)
// sanitize($input, $flags) -- input any variable, performs sanitization 
//           functions specified in flags. flags can be bitwise 
//           combination of PARANOID, SQL, SYSTEM, HTML, INT, FLOAT, LDAP, 
//           UTF8
///////////////////////////////////////
define("PARANOID", 1);
define("SQL", 2);
define("SYSTEM", 4);
define("HTML", 8);
define("INT", 16);
define("FLOAT", 32);
define("LDAP", 64);
define("UTF8", 128);

// internal function for utf8 decoding
// thanks to Jamie Pratt for noticing that PHP's function is a little 
// screwy

function my_utf8_decode($string)
{
return strtr($string, 
  "???????", 
  "SOZsozYYuAAAAAAACEEEEIIIIDNOOOOOOUUUUYsaaaaaaaceeeeiiiionoooooouuuuyy");
}

// paranoid sanitization -- only let the alphanumeric set through
function sanitize_paranoid_string($string, $min='', $max='')
{
  $string = preg_replace("/[^a-zA-Z0-9]/", "", $string);
  $len = strlen($string);
  if((($min != '') && ($len < $min)) || (($max != '') && ($len > $max)))
    return FALSE;
  return $string;
}

// sanitize a string in prep for passing a single argument to system() (or similar)
function sanitize_system_string($string, $min='', $max='')
{
  $pattern = '/(;|\||`|>|<|&|^|"|'."\n|\r|'".'|{|}|[|]|\)|\()/i'; // no piping, passing possible environment variables ($),
                           // seperate commands, nested execution, file redirection, 
                           // background processing, special commands (backspace, etc.), quotes
                           // newlines, or some other special characters
  $string = preg_replace($pattern, '', $string);
  $string = '"'.preg_replace('/\$/', '\\\$', $string).'"'; //make sure this is only interpretted as ONE argument
  $len = strlen($string);
  if((($min != '') && ($len < $min)) || (($max != '') && ($len > $max)))
    return FALSE;
  return $string;
}

// sanitize a string for SQL input (simple slash out quotes and slashes)
function sanitize_sql_string($string, $min='', $max='')
{
  $pattern[0] = '/(\\\\)/';
  $pattern[1] = "/\"/";
  $pattern[2] = "/'/";
  $replacement[0] = '\\\\\\';
  $replacement[1] = '\"';
  $replacement[2] = "\\'";
  $len = strlen($string);
  if((($min != '') && ($len < $min)) || (($max != '') && ($len > $max)))
    return FALSE;
  return preg_replace($pattern, $replacement, $string);
}

// sanitize a string for SQL input (simple slash out quotes and slashes)
function sanitize_ldap_string($string, $min='', $max='')
{
  $pattern = '/(\)|\(|\||&)/';
  $len = strlen($string);
  if((($min != '') && ($len < $min)) || (($max != '') && ($len > $max)))
    return FALSE;
  return preg_replace($pattern, '', $string);
}


// sanitize a string for HTML (make sure nothing gets interpretted!)
function sanitize_html_string($string)
{
  $pattern[0] = '/\&/';
  $pattern[1] = '/</';
  $pattern[2] = "/>/";
  $pattern[3] = '/\n/';
  $pattern[4] = '/"/';
  $pattern[5] = "/'/";
  $pattern[6] = "/%/";
  $pattern[7] = '/\(/';
  $pattern[8] = '/\)/';
  $pattern[9] = '/\+/';
  $pattern[10] = '/-/';
  $replacement[0] = '&amp;';
  $replacement[1] = '&lt;';
  $replacement[2] = '&gt;';
  $replacement[3] = '<br>';
  $replacement[4] = '&quot;';
  $replacement[5] = '&#39;';
  $replacement[6] = '&#37;';
  $replacement[7] = '&#40;';
  $replacement[8] = '&#41;';
  $replacement[9] = '&#43;';
  $replacement[10] = '&#45;';
  return preg_replace($pattern, $replacement, $string);
}

// make int int!
function sanitize_int($integer, $min='', $max='')
{
  $int = intval($integer);
  if((($min != '') && ($int < $min)) || (($max != '') && ($int > $max)))
    return FALSE;
  return $int;
}

// make float float!
function sanitize_float($float, $min='', $max='')
{
  $float = floatval($float);
  if((($min != '') && ($float < $min)) || (($max != '') && ($float > $max)))
    return FALSE;
  return $float;
}

// glue together all the other functions
function sanitize($input, $flags, $min='', $max='')
{
  if($flags & UTF8) $input = my_utf8_decode($input);
  if($flags & PARANOID) $input = sanitize_paranoid_string($input, $min, $max);
  if($flags & INT) $input = sanitize_int($input, $min, $max);
  if($flags & FLOAT) $input = sanitize_float($input, $min, $max);
  if($flags & HTML) $input = sanitize_html_string($input, $min, $max);
  if($flags & SQL) $input = sanitize_sql_string($input, $min, $max);
  if($flags & LDAP) $input = sanitize_ldap_string($input, $min, $max);
  if($flags & SYSTEM) $input = sanitize_system_string($input, $min, $max);
  return $input;
}

// end of sanitize
	function preview_text($TEXT, $LIMIT, $TAGS = 0) {
	
		// TRIM TEXT
		$TEXT = trim($TEXT);
	
		// STRIP TAGS IF PREVIEW IS WITHOUT HTML
		if ($TAGS == 0) $TEXT = preg_replace('/\s\s+/', ' ', strip_tags($TEXT));
	
		// IF STRLEN IS SMALLER THAN LIMIT RETURN
		if (strlen($TEXT) < $LIMIT) return $TEXT;
	
		if ($TAGS == 0) return substr($TEXT, 0, $LIMIT) . " ...";
		else {
	
			$COUNTER = 0;
			for ($i = 0; $i<= strlen($TEXT); $i++) {
	
				if ($TEXT{$i} == "<") $STOP = 1;
	
				if ($STOP != 1) {
	
					$COUNTER++;
				}
	
				if ($TEXT{$i} == ">") $STOP = 0;
				$RETURN .= $TEXT{$i};
	
				if ($COUNTER >= $LIMIT && $TEXT{$i} == " ") break;
	
			}
	
			return $RETURN . "...";
		}
	}	
	function ProperCase($strToConvert)
	{
		$strToReturn = ucwords(strtolower($strToConvert));
		return $strToReturn;
	
	} 
	
	function getAllStates($countryid ='', $stateid='')
	{
		//$states = new State();
		$all_obj = new AllTables();
		
		if($countryid != ''){
			
			$sql = "select * from mststate where countryid=".$countryid." ORDER BY StateName, StateId";
		}
		else {
			
	   	$sql = "select * from mststate ORDER BY StateName, StateId";;
	   }
	   
	   $statelist = $all_obj->getInfo('',$sql);
	   $rowcount =count($statelist);
		
		$optionvalue .= "<option value=''>Select state</option>";
		
		for($i=0;$i<$rowcount;$i++){
			
			$statename =$statelist[$i]['StateName'];
			$stateIds =$statelist[$i]['StateId'];
			
			if($stateid == $stateIds){
				
				$optionvalue .= "<option value='".$stateid."-".$statename."' selected='selected'>".$statename."</option>";
				
			}else{
			
				$optionvalue .= "<option value='".$stateid."-".$statename."'>".$statename."</option>";
			}		
		}
		
		
		return $optionvalue;
	}
	
	function getState($countryname='',$stateid="")
{
		$all_obj    			= 	new AllTables();
		
		if($countryname != '')
		{
			$query ="SELECT * FROM mststate a 
						inner join mstcountry b on a.countryid = b.countryid 
						where b.countryname = '".$countryname."' ";
		}

			$state	         = $all_obj -> getInfo("",$query);
		
			$resultscount = count($state);
			for($i=0;$i<$resultscount;$i++)
			{
				if($stateid == $state[$i]['StateId'])
				{
					$statelist .= '<option value="'.$state[$i]["StateId"].'-'.$state[$i]["StateName"].'" selected="">'.$state[$i]["StateName"].'</option>';	
				}
				else if($stateid != $state[$i]['StateId'])
				{
					$statelist .= '<option value="'.$state[$i]["StateId"].'-'.$state[$i]["StateName"].'">'.$state[$i]["StateName"].'</option>';	
				}
			}
		//return $countryid;
	return $statelist; 
}
	
	function getAllCountryListForCombo($GCountry='')
	{
		$conuntries = new State();
		
		$countrylist = $conuntries->getState("","select * from mstcountry");
		
		$rowcount = count($countrylist);
		
		$strCountryList = "";
		
		if ($rowcount > 0)
		{
			
			for($i=0;$i<$rowcount;$i++) 
			{	
				
				if(strtolower($GCountry) == strtolower($countrylist[$i]['countryname']))
				{
					$strCountryList .= '<option value="'.$countrylist[$i]["countryid"].'-'.$countrylist[$i]["countryname"].'" selected="selected">'.ucwords(strtolower($countrylist[$i]["countryname"])).'</option>';
				}
				else
				{	
					$strCountryList .= '<option value="'.$countrylist[$i]["countryid"].'-'.$countrylist[$i]["countryname"].'">'.ucwords(strtolower($countrylist[$i]["countryname"])).'</option>';
				}
			}
		}
		return $strCountryList;	
	}	
	
	
	function getAllStateListForCombo($stateid='',$countryid='',$countryname='',$statelist='')
	{
		$rowcount = (is_array($statelist))?count($statelist):0;
		
		$strstateList = "";
		
		if ($rowcount > 0)
		{
			
			for($i=0;$i<$rowcount;$i++) 
			{	
				if($stateid == $statelist[$i]['StateId'])
				{
					$strstateList .= '<option value="'.$statelist[$i]["StateId"].'-'.$statelist[$i]["StateName"].'" selected="selected">'.ucwords(strtolower($statelist[$i]["StateName"])).'</option>';
				}
				else
				{	
					$strstateList .= '<option value="'.$statelist[$i]["StateId"].'-'.$statelist[$i]["StateName"].'">'.ucwords(strtolower($statelist[$i]["StateName"])).'</option>';
				}
			}
		}
		return $strstateList;	
	}
	

		function FinancialYrStarAndEndDate($date='',$noofyearsback='0')
	{
	
	$monthtofind = ($date=='')?gmdate("n",mktime(null,null,null,date("n"),date("d"),date("Y"))):gmdate("n",mktime(null,null,null,substr($date,0,2),substr($date,3,2),substr($date,6,4)));
	
	$yeartofind = ($date=='')?gmdate("Y",mktime(null,null,null,date("n"),date("d"),date("Y"))):gmdate("Y",mktime(null,null,null,substr($date,0,2),substr($date,3,2),substr($date,6,4)))-$noofyearsback;
	
		if ($monthtofind < 4)
		{
			// jan feb or march month so deduct one from current year
			$FnYear = ($yeartofind-1);
			$FinancialYear= $FnYear."-".$yeartofind;  
		}
		else
		{
			$FnYear = ($yeartofind+1);
			$FinancialYear= '01-04-'.$yeartofind."||".'31-03-'.$FnYear;
		}
		
		return $FinancialYear;
	}

	
	function FinancialYr($date='',$noofyearsback='0')
	{
	
	//$monthtofind = ($date=='')?gmdate("n",mktime(null,null,null,date("n"),date("d"),date("Y"))):gmdate("n",mktime(null,null,null,substr($date,0,2),substr($date,3,2),substr($date,6,4)));
	//$yeartofind = ($date=='')?gmdate("Y",mktime(null,null,null,date("n"),date("d"),date("Y"))):gmdate("Y",mktime(null,null,null,substr($date,0,2),substr($date,3,2),substr($date,6,4)))-$noofyearsback;
	// major change by rajiv removed gmdate and changed it to date	
	$monthtofind = ($date=='')?date("n",mktime(null,null,null,date("n"),date("d"),date("Y"))):date("n",mktime(null,null,null,substr($date,0,2),substr($date,3,2),substr($date,6,4)));
	$yeartofind = ($date=='')?date("Y",mktime(null,null,null,date("n"),date("d"),date("Y"))):date("Y",mktime(null,null,null,substr($date,0,2),substr($date,3,2),substr($date,6,4)))-$noofyearsback;
	
		if ($monthtofind < 4)
		{
			// jan feb or march month so deduct one from current year
			$FnYear = ($yeartofind-1);
			$FinancialYear= $FnYear."-".$yeartofind;  
		}
		else
		{
			$FnYear = ($yeartofind+1);
			$FinancialYear= $yeartofind."-".$FnYear;
		}
		
		return $FinancialYear;
	}
	
	
	function CalculateYearInRangesBeforeSevenYear()
	{
	$currentfinancialyear = FinancialYr();
		
		$financialinfo			= explode('-',$currentfinancialyear);
		$year1			= $financialinfo[0];
		$year2			= $financialinfo[1];
		$currentyear1    = ($year1).'-04-01'."|".($year2).'-03-31';
		$options 	  .='<option value="all">All</option>';
		for($i=0;$i<10;$i++) 
		{
			$years 			= ($year1-$i).'-04-01'."|".($year2-$i).'-03-31';
			$yearinrange 	= "April ".($year1-$i)."-March ".($year2-$i);
			
			if($years == $currentyear1)
			{
			$options 	  .='<option value="'.$years.'" selected="selected">'.$yearinrange.'</option>';
		    }
		    else
		    {
		        $options 	  .='<option value="'.$years.'">'.$yearinrange.'</option>';

		    }
		}
		return $options; 
	}
	
	
	
	function getcompanylistwithinvoices($memberid='',$This_fy_year='',$next_fy_year='')
	{
	    $units = new AllTables();
		
		$unitlist = $units->getInfo("","select membercompanyid,companyname from user_company where memberid = $memberid");
		
		$rowcount = count($unitlist);
		
		if($This_fy_year == '0' && $next_fy_year == '0')
        {
            $where = "";

        }
        else
        {
		    $where = " and date(invoicedate) BETWEEN '$This_fy_year' and '$next_fy_year'";
        }
		
		$strunitlist = "";
		
		if ($rowcount > 0)
		{
			
			for($i=0;$i<$rowcount;$i++) 
			{	
                
			 //$strunitlist .= '<a href="details.php?membercompanyid='.$unitlist[$i]["membercompanyid"].'">'.ucwords(strtolower($unitlist[$i]["companyname"])).'</a></br>';
			  $membercompanyid = $unitlist[$i]["membercompanyid"];
			  $companyname     = $unitlist[$i]["companyname"];
			  
			  $quotelist = $units->getInfo("","SELECT a.memberinvoicesid FROM trninvoicetomember_frquotation a INNER JOIN trninvoicetomemberdetails_frquotation b on a.memberinvoicesid = b.memberinvoicesid WHERE quotes_proforma_invoice = 0 and isdeleted= 0 and billing_membercompanyid = $membercompanyid $where group by a.memberinvoicesid");
		      $quotecount = count($quotelist);
		      
		      $proformalist = $units->getInfo("","SELECT a.memberinvoicesid FROM trninvoicetomember_frproforma a INNER JOIN trninvoicetomemberdetails_frproforma b on a.memberinvoicesid = b.memberinvoicesid WHERE quotes_proforma_invoice = 1 and isdeleted= 0 and billing_membercompanyid = $membercompanyid $where group by a.memberinvoicesid");
		
		      $proformacount = count($proformalist); 
		      $invoicelist = $units->getInfo("","SELECT a.memberinvoicesid from mstmember x
					                            inner join trninvoicetomember a on x.memberid = a.memberid  
					                            INNER JOIN trninvoicetomemberdetails b on a.memberinvoicesid = b.memberinvoicesid 
					                            inner join mstclients e on b.billed_membercompanyid = e.clientcompanyid
					                            left join user_company_payment_header  c on a.memberinvoicesid = c.memberinvoicesid
					                            left join user_company_payment_detail  d on a.memberinvoicesid = d.memberinvoicesid
					                            where x.memberid = $memberid and a.quotes_proforma_invoice = 2 and a.isdeleted= 0 and a.billing_membercompanyid = $membercompanyid $where group by a.memberinvoicesid");
		
		      $invoicecount = count($invoicelist);
		      
		      
		      
              $strunitlist .= '<li>'.ucwords(strtolower($companyname)).'</li>';
		      $quotecountlist .= '<span>'.$quotecount.'</span></br>';
              $proformacountlist .= '<span>'.$proformacount.'</span></br>';
              $invoicecountlist .= '<span>'.$invoicecount.'</span></br>'; 
		      $companylist ='<td>'.$strunitlist.'</td><td>'.$quotecountlist.'</td><td>'.$proformacountlist.'</td><td>'.$invoicecountlist.'</td>';
		     
			  

            }
		}
		else
		{
		    $companylist ='<td></td><td></td><td></td><td></td>';

		}
		return $companylist;	

	}
	
	function getAllMemberListForCombo()
	{
		$units = new AllTables();
		
		$unitlist = $units->getInfo("","select * from mstmember");
		
		$rowcount = count($unitlist);
		
		$strCountryList = "";
		
		if ($rowcount > 0)
		{
			
			for($i=0;$i<$rowcount;$i++) 
			{	
				  $MemberName 	= $unitlist[$i]['MemberName'].' '.$unitlist[$i]['MemberSurName'];
                 $strCountryList .= '<option value="'.$unitlist[$i]["MemberID"].'">'.ucwords(strtolower($MemberName)).'</option>';
				
			}
		}
		return $strCountryList;	
	}
	
?>