<?php
//date functions//

function DateAdd($interval, $number, $date) {

    $date_time_array = getdate($date);
    $hours = $date_time_array['hours'];
    $minutes = $date_time_array['minutes'];
    $seconds = $date_time_array['seconds'];
    $month = $date_time_array['mon'];
    $day = $date_time_array['mday'];
    $year = $date_time_array['year'];

    switch ($interval) {
    
        case 'yyyy':
            $year+=$number;
            break;
        case 'q':
            $year+=($number*3);
            break;
        case 'm':
            $month+=$number;
            break;
        case 'y':
        case 'd':
        case 'w':
            $day+=$number;
            break;
        case 'ww':
            $day+=($number*7);
            break;
        case 'h':
            $hours+=$number;
            break;
        case 'n':
            $minutes+=$number;
            break;
        case 's':
            $seconds+=$number;
            break;            
    }
       $timestamp= mktime($hours,$minutes,$seconds,$month,$day,$year);
    return $timestamp;
}


function datediff($interval, $datefrom, $dateto, $using_timestamps = false) {
 /*
 $interval can be:
 yyyy - Number of full years
 q - Number of full quarters
 m - Number of full months
 y - Difference between day numbers
 (eg 1st Jan 2004 is "1", the first day. 2nd Feb 2003 is "33". The datediff is "-32".)
 d - Number of full days
 w - Number of full weekdays
 ww - Number of full weeks
 h - Number of full hours
 n - Number of full minutes
 s - Number of full seconds (default)
 */

 if (!$using_timestamps) {
 $datefrom = strtotime($datefrom, 0);
 $dateto = strtotime($dateto, 0);
 }
 $difference = $dateto - $datefrom; // Difference in seconds

 switch($interval) {

 case 'yyyy': // Number of full years
  
 $years_difference = floor($difference / 31536000);
 if (mktime(date("H", $datefrom), date("i", $datefrom), date("s", $datefrom), date("n", $datefrom), date("j", $datefrom), date("Y", $datefrom)+$years_difference) > $dateto) {
 $years_difference--;
 }
 if (mktime(date("H", $dateto), date("i", $dateto), date("s", $dateto), date("n", $dateto), date("j", $dateto), date("Y", $dateto)-($years_difference+1)) > $datefrom) {
 $years_difference++;
 }
 $datediff = $years_difference;
 break;
  
 case "q": // Number of full quarters
  
 $quarters_difference = floor($difference / 8035200);
 while (mktime(date("H", $datefrom), date("i", $datefrom), date("s", $datefrom), date("n", $datefrom)+($quarters_difference*3), date("j", $dateto), date("Y", $datefrom)) < $dateto) {
 $months_difference++;
 }
 $quarters_difference--;
 $datediff = $quarters_difference;
 break;
  
 case "m": // Number of full months
  
 $months_difference = floor($difference / 2678400);
 while (mktime(date("H", $datefrom), date("i", $datefrom), date("s", $datefrom), date("n", $datefrom)+($months_difference), date("j", $dateto), date("Y", $datefrom)) < $dateto) {
 $months_difference++;
 }
 $months_difference--;
 $datediff = $months_difference;
 break;
  
 case 'y': // Difference between day numbers
  
 $datediff = date("z", $dateto) - date("z", $datefrom);
 break;
  
 case "d": // Number of full days
  
 $datediff = floor($difference / 86400);
 break;
  
 case "w": // Number of full weekdays
  
 $days_difference = floor($difference / 86400);
 $weeks_difference = floor($days_difference / 7); // Complete weeks
 $first_day = date("w", $datefrom);
 $days_remainder = floor($days_difference % 7);
 $odd_days = $first_day + $days_remainder; // Do we have a Saturday or Sunday in the remainder?
 if ($odd_days > 7) { // Sunday
 $days_remainder--;
 }
 if ($odd_days > 6) { // Saturday
 $days_remainder--;
 }
 $datediff = ($weeks_difference * 5) + $days_remainder;
 break;
  
 case "ww": // Number of full weeks
  
 $datediff = floor($difference / 604800);
 break;
  
 case "h": // Number of full hours
  
 $datediff = floor($difference / 3600);
 break;
  
 case "n": // Number of full minutes
  
 $datediff = floor($difference / 60);
 break;
  
 default: // Number of full seconds (default)
  
 $datediff = $difference;
 break;
 }
  
 return $datediff;
  
 } 

function formatdate($date1,$dateformat="d-m-Y")
{
	
	$string = $date1; 	
	if ($string > "1900-12-30")
	{
	
		$string = $date1; 	
		$stringArray = explode("-", $string); 

		$date = mktime(0,0,0,$stringArray[1],$stringArray[2],$stringArray[0]); 

		$converteddate = date($dateformat, $date); 
		return ($converteddate);    	 
	}
}

function getquarter($month)
{
	switch ($month)
    {
    case ($month=='Jan' || $month=='Feb' || $month=='Mar'):
        $quarter = "4";
        break;
    case ($month=='Apr' || $month=='May' || $month=='Jun'):
        $quarter = "1";
        break;
    case ($month=='Jul' || $month=='Aug' || $month=='Sep'):
        $quarter = "2";
        break;
    case ($month=='Oct' || $month=='Nov' || $month=='Dec'):
        $quarter = "3";
        break;
    } 
    return $quarter;
}

//-----------------format numbers--------------------------//

function format_number($strAmount)
{ 		
	list($OrgAmount,$DotAmount)= split ('[.]', $strAmount);	
//	list($OrgAmount)= split ('[.]', $strAmount);	
	
	// -- If Decimal Amount is Blank Then Make It '00 ---- ////
	
	if ($DotAmount =='')
	{
		$DotAmount ='00';
	}
	else if (strlen($DotAmount)==1)
    {
		$DotAmount .= "0"; 
    }	    
    // -- End Decimal Amount
    
    $strlength	 = strlen($OrgAmount);			// Length Of Amount 
        
    if ($strlength >'0')
    {
		if ($strlength == '1')
		{
			$a = substr($OrgAmount,"0","1");
			$strAm ="$a.$DotAmount";					
			return($strAm); 					
		}
		else if ($strlength =='2')
		{
			$a = substr($OrgAmount,"0","2");
			$strAm ="$a.$DotAmount";					
			return($strAm); 					
		}
		else if ($strlength =='3')
		{
			$a = substr($OrgAmount,"0","3");
			$strAm ="$a.$DotAmount";					
			return($strAm); 				
		}
		else if ($strlength =='4')
		{
			$b = substr($OrgAmount,"1","3");
			$a = substr($OrgAmount,"0","1");
			$strAm ="$a,$b.$DotAmount";					
			return($strAm); 		
		}
		else if ($strlength =='5')
		{
			$b = substr($OrgAmount,"2","3");
			$a = substr($OrgAmount,"0","2");
			$strAm ="$a,$b.$DotAmount";					
			return($strAm); 				
		}
		else if ($strlength =='6')
		{
			$c = substr($OrgAmount,"3","3");
			$b = substr($OrgAmount,"1","2");
			$a = substr($OrgAmount,"0","1");
			$strAm ="$a,$b,$c.$DotAmount";					
			return($strAm); 		
		}
		else if ($strlength =='7')
		{
			$c = substr($OrgAmount,"4","3");
			$b = substr($OrgAmount,"2","2");
			$a = substr($OrgAmount,"0","2");
			$strAm ="$a,$b,$c.$DotAmount";					
			return($strAm); 
							
		}
		else if ($strlength =='8')
		{
			$d = substr($OrgAmount,"5","3");
			$c = substr($OrgAmount,"3","2");
			$b = substr($OrgAmount,"1","2");
			$a = substr($OrgAmount,"0","1");
			$strAm ="$a,$b,$c,$d.$DotAmount";					
			return($strAm); 		
		}
		else if ($strlength =='9')
		{
			$d = substr($OrgAmount,"6","3");
			$c = substr($OrgAmount,"4","2");
			$b = substr($OrgAmount,"2","2");
			$a = substr($OrgAmount,"0","2");
			$strAm ="$a,$b,$c,$d.$DotAmount";					
			return($strAm); 
		}
		else if ($strlength =='10')
		{	
			$e = substr($OrgAmount,"7","3");
			$d = substr($OrgAmount,"5","2");
			$c = substr($OrgAmount,"3","2");
			$b = substr($OrgAmount,"1","2");
			$a = substr($OrgAmount,"0","1");
			
			$strAm ="$a,$b,$c,$d,$e.$DotAmount";					
			return($strAm); 
		}
		else if ($strlength =='11')
		{
			$e = substr($OrgAmount,"8","3");
			$d = substr($OrgAmount,"6","2");
			$c = substr($OrgAmount,"4","2");
			$b = substr($OrgAmount,"2","2");
			$a = substr($OrgAmount,"0","2");
			$strAm ="$a,$b,$c,$d,$e.$DotAmount";					
			return($strAm); 
		}		
	}
}



//------------------------------//
	
	
	function replaceForLink($strToReplace)
	{
		$strToReturn = str_replace(" ","_",$strToReplace);
		$strToReturn = str_replace("/","---",$strToReturn);
		return $strToReturn;
	}
	
	function replaceForNormalText($strLink)
	{
		$strNormalText = str_replace("_"," ",$strLink);
		$strNormalText = str_replace("---","/",$strNormalText);
		return $strNormalText;
	}
	
	function DeleteCacheFiles($fromdir, $tm, $recursed = 1 ) {
	if ($fromdir == "" or !is_dir($fromdir)) {
		echo ('Invalid directory');
		return false;
	}

	$filelist = array();
	$dir = opendir($fromdir);

	while($file = readdir($dir)) {
		if($file == "." || $file == ".." || $file == 'readme.txt' || $file == 'index.html' || $file == 'index.htm' || $file == 'lasttime.dat' ) {
			continue;
		} elseif (is_dir($fromdir."/".$file)) {
			if ($recursed == 1) {
				$temp = DeleteCacheFiles($fromdir."/".$file, $recursed);
			}
		} elseif (file_exists($fromdir."/".$file) && filemtime($fromdir."/".$file) < $tm) {
			unlink($fromdir."/".$file);
		}
	}

	closedir($dir);
	return true;
	
	}

	
	function deleteCache() {
	global $config;
	/* This function will delete cache files.. */
	$tm = time() - $config['time_cache_expiry']*60;
	$lasttime = 0;
	if (is_readable(CACHE_DIR.'lasttime.dat')) 
	{
		$lt = file(CACHE_DIR.'lasttime.dat');
		$lasttime = trim($lt[0]);
	}
	if ($lasttime < $tm) 
		{
			DeleteCacheFiles(CACHE_DIR,$tm);
			$fp = @fopen(CACHE_DIR.'lasttime.dat','wb');
			if ($fp) 
			{
				fwrite($fp, time());
				fclose($fp);
			}
		}
	}	

/* convert numbers to words */


  $nwords = array(  "", "One", "Two", "Three", "Four", "Five", "Six", 
	      	  "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen", 
	      	  "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eighteen", 
	     	  "Nineteen", "Twenty", 30 => "Thirty", 40 => "Fourty",
                     50 => "Fifty", 60 => "Sixty", 70 => "Seventy", 80 => "Eigthy",
                     90 => "Ninety" );

function number_to_words ($x)
{
     global $nwords;
     if(!is_numeric($x))
     {
         $w = 'a';
     }
     else if(fmod($x, 1) != 0)
     {
        //$w = 'b';
        list($OrgAmount,$DotAmount)= split ('[.]', $x);
        if (strlen($DotAmount)==1)
        {
			$DotAmount .= "0"; 
        }
        $paise = " and paise ".number_to_words($DotAmount). " ";
        $w = number_to_words($OrgAmount);
     }
     else
     {
         if($x < 0)
         {
             $w = 'minus ';
             $x = -$x;
         }else{
             $w = '';
         }
         if($x < 21)
         {
             $w .= $nwords[$x];
         }else if($x < 100)
         {
             $w .= $nwords[10 * floor($x/10)];
             $r = fmod($x, 10);
             if($r > 0)
             {
                 $w .= ' '. $nwords[$r];
             }
         } else if($x < 1000)
         {
		
             	$w .= $nwords[floor($x/100)] .' hundred';
             $r = fmod($x, 100);
             if($r > 0)
             {
                 $w .= ' '. number_to_words($r);
             }
         } else if($x < 100000)
         {
         	$w .= number_to_words(floor($x/1000)) .' thousand';
             $r = fmod($x, 1000);
             if($r > 0)
             {
                 $w .= ' ';
                 if($r < 100)
                 {
                     $w .= ' ';
                 }
                 $w .= number_to_words($r);
             }
         } else if ($x < 10000000) {
             $w .= number_to_words(floor($x/100000)) .' Lacs';
             $r = fmod($x, 100000);
             if($r > 0)
             {
                 $w .= ' ';
                 if($r < 100)
                 {
                     $word .= ' ';
                 }
                 $w .= number_to_words($r);
             }
         }else  {
             $w .= number_to_words(floor($x/10000000)) .' Crore';
             $r = fmod($x, 10000000);
             if($r > 0)
             {
                 $w .= ' ';
                 if($r < 100)
                 {
                     $word .= ' ';
                 }
                 $w .= number_to_words($r);
             }
         }
     }
     return $w." ".$paise;
}
//echo number_to_words(11875494);

function splitString($strToSplit,$SplitChar,$ReturnValueNumber)
{
	$strSplit = split($SplitChar,$strToSplit);
	if (is_array($strSplit))
	{
		$retVal = $strSplit[$ReturnValueNumber];	
	}
	else
	{
		$retVal = $strSplit;
	}
	return $retVal;
}

function copyFile($source,$destination)
	{
		$sourcefile = $source;
		$destfile = $destination;

		if (file_exists($sourcefile)) {
			if (!copy($sourcefile, $destfile)) {
				//echo "failed to copy $file...\n";
				return false;
			} 
			else
			{
				return true;
			}
		}
		else
		{
			return false;
		}	
	}
	/*------------------------------------------------------------------------------
	 * Delete file 
	 * Returns success or failure
	_______________________________________________________________________________*/
	function deleteFile($fileNameToDelete)
	{
		$old = getcwd(); // Save the current directory
		
		$path_parts = pathinfo($fileNameToDelete);
		$path_to_file = $path_parts['dirname'];
		
		chdir($path_to_file);
		
		if (!unlink($fileNameToDelete)) {
			chdir($old); // Restore the old working directory    
			return false;
		} 
		else
		{
			chdir($old); // Restore the old working directory
			return true;
		}
	} 

	function preview_text($TEXT, $LIMIT, $TAGS = 0) {

    // TRIM TEXT
    $TEXT = trim($TEXT);

    // STRIP TAGS IF PREVIEW IS WITHOUT HTML
    if ($TAGS == 0) $TEXT = preg_replace('/\s\s+/', ' ', strip_tags($TEXT));

    // IF STRLEN IS SMALLER THAN LIMIT RETURN
    if (strlen($TEXT) < $LIMIT) return $TEXT;

    if ($TAGS == 0) return substr($TEXT, 0, $LIMIT) . " ...";
    else {

        $COUNTER = 0;
        for ($i = 0; $i<= strlen($TEXT); $i++) {

            if ($TEXT{$i} == "<") $STOP = 1;

            if ($STOP != 1) {

                $COUNTER++;
            }

            if ($TEXT{$i} == ">") $STOP = 0;
            $RETURN .= $TEXT{$i};

            if ($COUNTER >= $LIMIT && $TEXT{$i} == " ") break;

        }

        return $RETURN . "...";
    }
}

///////////////////////////////////////
// sanitize.inc.php
// Sanitization functions for PHP
// by: Gavin Zuchlinski, Jamie Pratt, Hokkaido
// webpage: http://libox.net
// Last modified: September 27, 2003
//
// Many thanks to those on the webappsec list for helping me improve these functions
///////////////////////////////////////
// Function list:
// sanitize_paranoid_string($string) -- input string, returns string stripped of all non 
//           alphanumeric
// sanitize_system_string($string) -- input string, returns string stripped of special
//           characters
// sanitize_sql_string($string) -- input string, returns string with slashed out quotes
// sanitize_html_string($string) -- input string, returns string with html replacements
//           for special characters
// sanitize_int($integer) -- input integer, returns ONLY the integer (no extraneous 
//           characters
// sanitize_float($float) -- input float, returns ONLY the float (no extraneous 
//           characters)
// sanitize($input, $flags) -- input any variable, performs sanitization 
//           functions specified in flags. flags can be bitwise 
//           combination of PARANOID, SQL, SYSTEM, HTML, INT, FLOAT, LDAP, 
//           UTF8
///////////////////////////////////////
define("PARANOID", 1);
define("SQL", 2);
define("SYSTEM", 4);
define("HTML", 8);
define("INT", 16);
define("FLOAT", 32);
define("LDAP", 64);
define("UTF8", 128);

// internal function for utf8 decoding
// thanks to Jamie Pratt for noticing that PHP's function is a little 
// screwy

function my_utf8_decode($string)
{
return strtr($string, 
  "???????\A5\B5\C0\C1\C2\C3\C4\C5\C6\C7\C8\C9\CA\CB\CC\CD\CE\CF\D0\D1\D2\D3\D4\D5\D6\D8\D9\DA\DB\DC\DD\DF\E0\E1\E2\E3\E4\E5\E6\E7\E8\E9\EA\EB\EC\ED\EE\EF\F0\F1\F2\F3\F4\F5\F6\F8\F9\FA\FB\FC\FD\FF", 
  "SOZsozYYuAAAAAAACEEEEIIIIDNOOOOOOUUUUYsaaaaaaaceeeeiiiionoooooouuuuyy");
}

// paranoid sanitization -- only let the alphanumeric set through
function sanitize_paranoid_string($string, $min='', $max='')
{
  $string = preg_replace("/[^a-zA-Z0-9]/", "", $string);
  $len = strlen($string);
  if((($min != '') && ($len < $min)) || (($max != '') && ($len > $max)))
    return FALSE;
  return $string;
}

// sanitize a string in prep for passing a single argument to system() (or similar)
function sanitize_system_string($string, $min='', $max='')
{
  $pattern = '/(;|\||`|>|<|&|^|"|'."\n|\r|'".'|{|}|[|]|\)|\()/i'; // no piping, passing possible environment variables ($),
                           // seperate commands, nested execution, file redirection, 
                           // background processing, special commands (backspace, etc.), quotes
                           // newlines, or some other special characters
  $string = preg_replace($pattern, '', $string);
  $string = '"'.preg_replace('/\$/', '\\\$', $string).'"'; //make sure this is only interpretted as ONE argument
  $len = strlen($string);
  if((($min != '') && ($len < $min)) || (($max != '') && ($len > $max)))
    return FALSE;
  return $string;
}

// sanitize a string for SQL input (simple slash out quotes and slashes)
function sanitize_sql_string($string, $min='', $max='')
{
  $pattern[0] = '/(\\\\)/';
  $pattern[1] = "/\"/";
  $pattern[2] = "/'/";
  $replacement[0] = '\\\\\\';
  $replacement[1] = '\"';
  $replacement[2] = "\\'";
  $len = strlen($string);
  if((($min != '') && ($len < $min)) || (($max != '') && ($len > $max)))
    return FALSE;
  return preg_replace($pattern, $replacement, $string);
}

function toAscii($str, $replace=array(), $delimiter='-') {
if( !empty($replace) ) {
	$str = str_replace((array)$replace, ' ', $str);
	}
	//$clean = iconv('UTF-8', 'ASCII//TRANSLIT', $str);
	$clean = mb_convert_encoding($str,'UTF-8', 'ASCII//TRANSLIT');
	$clean = preg_replace("/[^a-zA-Z0-9\/_|+ -]/", '', $clean);
	$clean = strtolower(trim($clean, '-'));
	$clean = preg_replace("/[\/_|+ -]+/", $delimiter, $clean);

	return $clean;
}

function ProperCase($strToConvert)
{
	$strToReturn = ucwords(strtoupper($strToConvert));
	return $strToReturn;

} 	
	
// sanitize a string for SQL input (simple slash out quotes and slashes)
function sanitize_ldap_string($string, $min='', $max='')
{
  $pattern = '/(\)|\(|\||&)/';
  $len = strlen($string);
  if((($min != '') && ($len < $min)) || (($max != '') && ($len > $max)))
    return FALSE;
  return preg_replace($pattern, '', $string);
}


// sanitize a string for HTML (make sure nothing gets interpretted!)
function sanitize_html_string($string)
{
  $pattern[0] = '/\&/';
  $pattern[1] = '/</';
  $pattern[2] = "/>/";
  $pattern[3] = '/\n/';
  $pattern[4] = '/"/';
  $pattern[5] = "/'/";
  $pattern[6] = "/%/";
  $pattern[7] = '/\(/';
  $pattern[8] = '/\)/';
  $pattern[9] = '/\+/';
  $pattern[10] = '/-/';
  $replacement[0] = '&amp;';
  $replacement[1] = '&lt;';
  $replacement[2] = '&gt;';
  $replacement[3] = '<br>';
  $replacement[4] = '&quot;';
  $replacement[5] = '&#39;';
  $replacement[6] = '&#37;';
  $replacement[7] = '&#40;';
  $replacement[8] = '&#41;';
  $replacement[9] = '&#43;';
  $replacement[10] = '&#45;';
  return preg_replace($pattern, $replacement, $string);
}

// make int int!
function sanitize_int($integer, $min='', $max='')
{
  $int = intval($integer);
  if((($min != '') && ($int < $min)) || (($max != '') && ($int > $max)))
    return FALSE;
  return $int;
}

// make float float!
function sanitize_float($float, $min='', $max='')
{
  $float = floatval($float);
  if((($min != '') && ($float < $min)) || (($max != '') && ($float > $max)))
    return FALSE;
  return $float;
}

// glue together all the other functions
function sanitize($input, $flags, $min='', $max='')
{
  if($flags & UTF8) $input = my_utf8_decode($input);
  if($flags & PARANOID) $input = sanitize_paranoid_string($input, $min, $max);
  if($flags & INT) $input = sanitize_int($input, $min, $max);
  if($flags & FLOAT) $input = sanitize_float($input, $min, $max);
  if($flags & HTML) $input = sanitize_html_string($input, $min, $max);
  if($flags & SQL) $input = sanitize_sql_string($input, $min, $max);
  if($flags & LDAP) $input = sanitize_ldap_string($input, $min, $max);
  if($flags & SYSTEM) $input = sanitize_system_string($input, $min, $max);
  return $input;
}





//for finding banner image,destination url by enter zoneid
function findzonevalidation($zoneid,$websitename='',$productname='',$maingroupid='',$js='')
	{
		
		//$calculatedate = mktime(0,0,0,date("m"),date("d-1"),date("Y"));
	 	//$latestdate	=	date("Y-m-d", $calculatedate);
		$latestdate	=	date("Y-m-d");
		$curentdate	=	date('Y-m-d h:i:s');
		$currentuseripaddress	=	$_SERVER['REMOTE_ADDR'];
		$testclass = new AllTables();
		if($zoneid)
			{
					/*$bannersizelist = $testclass->getInfo('', "SELECT bannerfilename,destinationurl from trnbannerorderdetail a inner join trnbannerorder b on a.trnbannerorderid=b.bannerorderid where a.zoneid='$zoneid' and b.enddate <='$latestdate' and b.bannerisactive='0'");*/
					 if ($productname!='')
					 {
					 	$productname = urldecode($productname);
					 	$bannersizelist = $testclass->getInfo('', "SELECT  bannerfilename,destinationurl,b.txtAdtitle,b.txtAddescription,b.txtAdd_Display_Url,b.bannerorderid,c.height,c.width,a.trnbannerorderdetailid from trnbannerorderdetail a inner join trnbannerorder b on a.trnbannerorderid=b.bannerorderid left join mstzone c on a.zoneid=c.zoneid where a.zoneid='$zoneid' and productsearchterm='$productname' and b.startdate <='$latestdate' and b.enddate >='$latestdate' and b.bannerisactive='1' and a.bannerShowOnWebsiteID=(select websiteid from mstwebsites where websitename='$websitename')");
						//echo "SELECT  bannerfilename,destinationurl,b.txtAdtitle,b.txtAddescription,b.txtAdd_Display_Url,b.bannerorderid,c.height,c.width,a.trnbannerorderdetailid from trnbannerorderdetail a inner join trnbannerorder b on a.trnbannerorderid=b.bannerorderid left join mstzone c on a.zoneid=c.zoneid where a.zoneid='$zoneid' and productsearchterm='$productname' and b.startdate <='$latestdate' and b.enddate >='$latestdate' and b.bannerisactive='1' and a.bannerShowOnWebsiteID=(select websiteid from mstwebsites where websitename='$websitename')";
					}
					else if ($maingroupid!='')
					{
						$sqlBanner	=	"SELECT bannerfilename,isflashimg,flashbackupimg,destinationurl,b.txtAdtitle,b.txtAddescription,b.txtAdd_Display_Url,b.bannerorderid,c.height,
						c.width,a.trnbannerorderdetailid from trnbannerorderdetail a inner join trnbannerorder b on a.trnbannerorderid=b.bannerorderid left join mstzone c on a.zoneid=c.zoneid where a.zoneid='$zoneid' and b.startdate <='$latestdate' and b.enddate >='$latestdate' and b.bannerisactive='1' and bannermaingroupid='$maingroupid' and a.bannerShowOnWebsiteID=(select websiteid from mstwebsites where websitename='$websitename')";

						$bannersizelist = $testclass->getInfo('', $sqlBanner);
					}
					else
					{	
						//$bannersizelist = $testclass->getInfo('', "SELECT bannerfilename,destinationurl,b.txtAdtitle,b.txtAddescription,b.txtAdd_Display_Url,b.bannerorderid,c.height,c.width from trnbannerorderdetail a inner join trnbannerorder b on a.trnbannerorderid=b.bannerorderid left join mstzone c on a.zoneid=c.zoneid where a.zoneid='$zoneid' and b.enddate >='$latestdate' and b.bannerisactive='1'");
						/*org $sqlBanner	=	"SELECT bannerfilename,isflashimg,flashbackupimg,destinationurl,b.txtAdtitle,b.txtAddescription,b.txtAdd_Display_Url,b.bannerorderid,c.height,
						c.width,a.trnbannerorderdetailid from trnbannerorderdetail a inner join trnbannerorder b on a.trnbannerorderid=b.bannerorderid left join mstzone c on a.zoneid=c.zoneid where a.zoneid='$zoneid' and b.startdate <='$latestdate' and b.enddate >='$latestdate' and b.bannerisactive='1' and productsearchterm='' and bannermaingroupid = 0 and a.bannerShowOnWebsiteID=(select websiteid from mstwebsites where websitename='$websitename')";
						*/
						
						$sqlBanner	=	"SELECT b.bannerorderid,c.height,b.bannerfilename,c.width
						 					from trnbannerorder b  inner join mstzone c on b.zoneid=c.zoneid 
						 					where b.zoneid='$zoneid' and b.startdate <='$latestdate' and b.enddate >='$latestdate' and b.bannerisactive='1'";						
						
						//echo $sqlBanner;
						$bannersizelist = $testclass->getInfo('', $sqlBanner);
						//print_r($bannersizelist);
					}	
					 //echo "SELECT bannerfilename,destinationurl,b.bannerorderid,c.height,c.width from trnbannerorderdetail a inner join trnbannerorder b on a.trnbannerorderid=b.bannerorderid left join mstzone c on a.zoneid=c.zoneid where a.zoneid='$zoneid' and b.enddate >='$latestdate' and b.bannerisactive='1'";
					/* changes made by rajiv on 11th may to show common banner for zone 
					   commented again by rajiv on 24th july 2015
						if (!$bannersizelist)
						{
						$sqlBannerCommon	=	"SELECT  bannerfilename,isflashimg,flashbackupimg,destinationurl,b.txtAdtitle,b.txtAddescription,b.txtAdd_Display_Url,b.bannerorderid,c.height,
						c.width,a.trnbannerorderdetailid from trnbannerorderdetail a inner join trnbannerorder b on a.trnbannerorderid=b.bannerorderid left join mstzone c on a.zoneid=c.zoneid where a.zoneid='$zoneid' and b.startdate <='$latestdate' and b.enddate >='$latestdate' and b.bannerisactive='1' and productsearchterm='' and bannermaingroupid=0 and a.bannerShowOnWebsiteID=(select websiteid from mstwebsites where websitename='$websitename')";
						$bannersizelist = $testclass->getInfo('', $sqlBannerCommon);
						}
					*/
			}			
		
		if ($bannersizelist)
			{
				
				$rowcount = count($bannersizelist);
				$lastrowcount	= $rowcount-1;	
				$bannerno = rand(0,$lastrowcount);
				$bannerfile_checkname = BANNER_IMAGE_PATH.$bannersizelist[$bannerno]['bannerfilename'];
				$bannerfilename	= BANNER_PHOTO_PATH.$bannersizelist[$bannerno]['bannerfilename'];
				$bannersizeheight	=	$bannersizelist[$bannerno]['height'];
				$bannersizewidth	=	$bannersizelist[$bannerno]['width'];	
				 $trnbannerorderid	=	$bannersizelist[$bannerno]['bannerorderid'];
				 $bannerorderDetailid	=	$bannersizelist[$bannerno]['trnbannerorderdetailid'];
						//for count banner view
					if($trnbannerorderid > 0)
						{	
							$newrecord['bannerorderdetailid']	=	$bannerorderDetailid;
							$newrecord['trnbannerorderid']	=	$trnbannerorderid;	
							$newrecord['datetime']			=	$curentdate;
							$newrecord['visitorip']			=	$currentuseripaddress;
							$newrecord['bannerviews']		=	'1';
							$tableName	=	"trncurrentbannerstats";
							
							$curdate = date('Y-m-d h:i:s');
			
							$curfiledate = date('Y-m-d-H');

							//$my_file = BASE_DIR.'logs/bannerviews-file-'.$curfiledate.'.log';
							$my_file = $bannerfile_checkname;
							$data = "INSERT INTO trncurrentbannerstats (trnbannerorderid,datetime,visitorip,bannerviews) VALUES ('$trnbannerorderid', '$curentdate', '$currentuseripaddress', '1');"."\n";
							if (file_exists($my_file))
							{
								$handle = fopen($my_file, 'a') or die('Cannot open file:  '.$my_file);
								fwrite($handle, $data);
								fclose($handle);
			
							}
							else
							{
								$newFile = fopen($my_file, 'w+') or die('Cannot open file:  '.$my_file);
								fwrite($newFile, $data);
								fclose($newFile);
								chmod($my_file, 0777);
							}
							//$updatecurrentbannerstats	=	$testclass->AddInfo($newrecord,$tableName);
						}
				//check when zone height width is zero
				//display txt banner zone
				
				// update banner stats here
				
				//
				if(($bannersizeheight==0) and	($bannersizewidth==0))
					{
						// text advertisement
						$Adtitle			=	$bannersizelist[$bannerno]['txtAdtitle'];
						$Addescription		=	$bannersizelist[$bannerno]['txtAddescription'];
						$Add_Display_Url	=	$bannersizelist[$bannerno]['txtAdd_Display_Url'];	
						//$bannertoreturn = '<a href="showbanner.php?bannerorderid='.$trnbannerorderid.'" target="_new" ><img src="'.$bannerfilename.'" height="200" width="200" ></a>';
						$bannertoreturn ='<div id="advertisementdiv">';
						$bannertoreturn .='		<div style="margin:2px;width:100%;">';
						$bannertoreturn .='			<a href="'.DOC_ROOT.'showbanner.php?bannerorderid='.base64_encode($trnbannerorderid).'&bannerorderDetailid='.base64_encode($bannerorderDetailid).'" target="_new" ><strong>'.$Adtitle.'</strong></a>';
						$bannertoreturn .='		</div>';
							
						$bannertoreturn .='		<div style="float:left;width:110px; max-width:110px;padding:2px;">'; 
						$bannertoreturn .='			<a href="'.DOC_ROOT.'showbanner.php?bannerorderid='.base64_encode($trnbannerorderid).'&bannerorderDetailid='.base64_encode($bannerorderDetailid).'" target="_new" ><img src='.$bannerfilename.' height="100" width="100" ></a>'; 
						$bannertoreturn .='		</div>'; 
							   
						$bannertoreturn .='		<div class="smalladdiv">'; 
						$bannertoreturn .='			<a href="'.DOC_ROOT.'showbanner.php?bannerorderid='.base64_encode($trnbannerorderid).'&bannerorderDetailid='.base64_encode($bannerorderDetailid).'" target="_new" >'.$Addescription.'Read More</a>';
						$bannertoreturn .='		</div>';  
							  
						$bannertoreturn .='		<div style="float:left; margin-left:5px;">';
						$bannertoreturn .='			 <a href="'.DOC_ROOT.'showbanner.php?bannerorderid='.base64_encode($trnbannerorderid).'&bannerorderDetailid='.base64_encode($bannerorderDetailid).'" target="_new" >'.$Add_Display_Url.'</a>'; 
						$bannertoreturn .='		</div>'; 
						$bannertoreturn .='</div>';
					}
				else
					{ 
						if($bannersizelist[$bannerno]['isflashimg']==1)
							{
								$flashbackupimg	=	BANNER_IMAGE_PATH.$bannersizelist[$bannerno]['flashbackupimg'];
								//echo 'Flash image';
								//flash img start here
								$time	=	strtotime("now");
								$randomdivid = base64_encode($time.rand(1, 100));
								$encodedurl	=	urlencode (DOC_ROOT.'showbanner.php?bannerorderid='.base64_encode($trnbannerorderid).'&bannerorderDetailid='.base64_encode($bannerorderDetailid));
								$urltogo	=	DOC_ROOT.'showbanner.php?bannerorderid='.base64_encode($trnbannerorderid).'&bannerorderDetailid='.base64_encode($bannerorderDetailid);
								$bannertoreturn	.='<!DOCTYPE html><html lang="en">';
								$bannertoreturn	='<head><title>Advertisement</title>'."\n";
								$bannertoreturn	.='<script type="text/javascript" src="'.JS_DIR.'flashBanneroutput.js"></script>'."\n";
								$bannertoreturn	.='	<style type="text/css">'."\n";
								$bannertoreturn	.='		body {margin:0; height:100%; background-color:transparent; width:100%; text-align:center;}'."\n";
								$bannertoreturn	.='	</style></head><body>'."\n";
								$bannertoreturn	.='<div id="'.$randomdivid.'" style="display: inline;">'."\n";
								$bannertoreturn	.='		<a href ="'.$urltogo.'" />'."\n";
								$bannertoreturn	.='			<img src="'.$flashbackupimg.'" height="'.$bannersizeheight.'" width="'.$bannersizewidth.'"/>'."\n";
								$bannertoreturn	.='		</a>'."\n";
								$bannertoreturn	.='</div>'."\n";
								$bannertoreturn	.='<script type="text/javascript">'."\n";
								
								$bannertoreturn	.='	  var ox_swf = new FlashObject("'.$bannerfilename.'", "Advertisement", "'.$bannersizeheight.'","'.$bannersizewidth.'", "11");'."\n";
								//count number of click 
								$bannertoreturn	.='ox_swf.addVariable("clickTARGET", "_blank");'."\n";
								$bannertoreturn	.=' ox_swf.addVariable("clickTAG", "'.$encodedurl.'");'."\n";
								
								$bannertoreturn	.='	  ox_swf.addParam("allowScriptAccess","always");'."\n";
								$bannertoreturn	.='	  ox_swf.write("'.$randomdivid.'");'."\n";
								$bannertoreturn	.='	</script>'."\n";
								$bannertoreturn	.='	</body>'."\n";
								$bannertoreturn	.='	</html>'."\n";
								//flash img close here
							}
						else
							{
								
								if($bannersizelist[$bannerno]['bannerfilename']=='')
									{
										$bannertoreturn ='<a href="#">a</a>';
									}
								else
									{
										// image ads
										$bannertoreturn = '<a href="'.DOC_ROOT.'showbanner.php?bannerorderid='.base64_encode($trnbannerorderid).'&bannerorderDetailid='.base64_encode($bannerorderDetailid).'" target="_new" ><img src="'.$bannerfilename.'" height="'.$bannersizeheight.'" width="'.$bannersizewidth.'" border="0"></a>';
									}
							}
				 	}
				 
				 
			}
			
		else
			{
					// show default banners here 
					$bannerfilename = BANNER_IMAGE_PATH;//define default banner size
					//for count banner view
					if($trnbannerorderid > 0)
						{
							$newrecord['bannerorderdetailid']	=	$bannerorderDetailid;
							$newrecord['trnbannerorderid']	=	$trnbannerorderid;	
							$newrecord['datetime']			=	$curentdate;
							$newrecord['visitorip']			=	$currentuseripaddress;
							$newrecord['bannerviews']		=	'1';
							$tableName	=	"trncurrentbannerstats";
							$updatecurrentbannerstats	=	$testclass->AddInfo($newrecord,$tableName);
						}
					if($bannersizelist[$bannerno]['bannerfilename']=='')
							{
								$bannertoreturn ='';
							}
						else
							{
								 $bannertoreturn = '<a href="showbanner.php?bannerorderid='.base64_encode($trnbannerorderid).'&bannerorderDetailid='.base64_encode($bannerorderDetailid).'" target="_new" ><img src="'.$bannerfilename.'" height="'.$bannersizeheight.'" width="'.$bannersizewidth.'"></a>';
							}
			
			
			}
			
			
		return $bannertoreturn;		
	}
	
	
	function getHomePageSliderImage() 
		{
			$testclass = new AllTables();
			
			//$sql = "SELECT a.galleryid,a.gallerytitle,b.photoid,b.phototitle,b.photoimagebig,b.photoimagethumb,b.photoimagesmall,b.photoorder,b.homesliderimage 
			//		FROM mstgallery a inner join mstgalleryphotos b on a.galleryid = b.galleryid where b.homesliderimage=1 order by b.photoorder=0,b.photoorder,b.photoid ASC ";
			
			/*$sql = "SELECT a.galleryid, a.gallerytitle, b.photoid, b.phototitle, b.photodate,
					 	b.photoimagebig, b.photoimagethumb, b.photoimagesmall, b.photoorder, b.homesliderimage
						FROM mstgallery a
						INNER JOIN mstgalleryphotos b ON a.galleryid = b.galleryid
						WHERE b.homesliderimage =1
						ORDER BY STR_TO_DATE( b.photodate, '%d-%m-%y' ) , b.photoid DESC ";			
			*/
			$sql = 'SELECT a.galleryid, a.gallerytitle, b.photoid, b.phototitle, b.photodate, b.photoimagebig,
					 	b.photoimagethumb, b.photoimagesmall, b.photoorder, b.homesliderimage
						FROM mstgallery a
						INNER JOIN mstgalleryphotos b ON a.galleryid = b.galleryid
						WHERE b.homesliderimage =1
						ORDER BY b.photoorder ASC';			
			
			
						
			$sliderimages = $testclass -> getInfo('',$sql);
			$rowcount = count($sliderimages);
			//print_r($sliderimages);
			for($i=0;$i<$rowcount;$i++) 
			{
			$photoid 			= 	$sliderimages[$i]['photoid'];
			$galleryid 			=	$sliderimages[$i]['galleryid'];
			$phototitle 		= 	$sliderimages[$i]['phototitle'];
			$photodesc 			=	$sliderimages[$i]['photodesc']; 
			$photoimagebig 	= 	$sliderimages[$i]['photoimagebig'];
			$photoorder 		= 	$sliderimages[$i]['photoorder'];
			$homesliderimage 	=	$sliderimages[$i]['homesliderimage'];
			$activeclass ='';
			if ($i==0)
			{
				$activeclass = "active";
			}
				
				$slider_array .= ' <div class="item '.$activeclass.'">
       									 <img src="'.GALLERY_PHOTO_PATH.$photoimagebig.'" alt="'.$phototitle.'" title="'.$phototitle.'" class="img-responsive" width="100%">
										 <div class="content">
									
										 <p class="bannerText"></p>
										
										 </div>
      								</div>';
									
									
			
			
			}
	// <p >'.$phototitle.'</p>  //// name of banner image
			//print_r($slider_array);
			return $slider_array;
			
			
			
		}
		
		
	function getGalleryListForCombo($exhibitionid='',$countryid='',$countryname='')
	{
		$testclass		=	new AllTables();
		
		if ($countryid!='')
		{
			$statelist = $testclass->getInfo("","SELECT * FROM mststate WHERE countryid ='".$countryid."' ORDER BY State asc");
		}
		else if($countryname!='')
		{
			$statelist = $testclass->getInfo("","SELECT * FROM mststate WHERE countryid in (Select countryid from mstcountry where countryname ='".$countryname."') ORDER BY State");
		}
		else
		{
			$statelist = $testclass->getInfo("","select * FROM mstgallery ORDER BY galleryid");
			//echo $statelist;
		}
		$rowcount = count($statelist);
		
		$strstatelist = "";
		
		if ($rowcount > 0)
		{
			for($i=0;$i<$rowcount;$i++) 
			{	
				if(strtoupper($exhibitionid)==$statelist[$i]['galleryid'])
				{
					$strstatelist .= "<option value='".$statelist[$i]['galleryid']."-".$statelist[$i]['gallerytitle']."' selected='selected'>".ucwords(strtolower($statelist[$i]['gallerytitle']))."</option>";
				}
				else
				{	
					$strstatelist .= "<option value='".$statelist[$i]['galleryid']."-".$statelist[$i]['gallerytitle']."'>".ucwords(strtolower($statelist[$i]['gallerytitle']))."</option>";
				}
			}
		}
		unset($testclass);
		return $strstatelist;	
	}
	
	
	
	
	function getResourcesForHeader()
	{
		$testclass		=	new AllTables();
		
			$linklist = $testclass->getInfo("","SELECT * FROM mstlinks WHERE status = 1 and is_resource = 1 ORDER BY displayorder asc");
		
		$rowcount = count($linklist);
		
		for($i=0;$i<$rowcount;$i++) {
		
		$linkname = $linklist[$i]['linkname'];
		$linknurl = $linklist[$i]['linkurl'];
		
		
		
		$retun_links .= '<li><a target="_blank"; href ="'.$linknurl.'">'.$linkname.'</a></li>';
		}
		return $retun_links;	
	}	
	
	
	function getImpNewsForHome()
	{
		$testclass		=	new AllTables();
		
			$linklist = $testclass->getInfo("","SELECT * FROM mstlinks WHERE status = 1 and is_imp = 1 ORDER BY displayorder=0,displayorder asc");
		
		$rowcount = count($linklist);
		
		for($i=0;$i<$rowcount;$i++) {
		
		$linkname = $linklist[$i]['linkname'];
		$linknurl = $linklist[$i]['linkurl'];
		$style_flag = $linklist[$i]['style'];
		
		if($style_flag == '1') {
		$style = 'style="font-size:16px; color:#F00;"';
		}
		elseif($style_flag == '2') {
		$style = 'style="font-size:16px; color:#1a66ff;"';
		}
		else {	
		$style = 'style="font-size:16px; color:#269900;"';
		}
		
		$retun_links .= '<a target="_blank"; '.$style.' href ="'.$linknurl.'">'.$linkname.'</a>&nbsp;&nbsp;&nbsp;&nbsp;';
		}
		return $retun_links;	
	}
	
	
	function getContactUs()
	{
		$testclass		=	new AllTables();
		
			$contactuslist = $testclass->getInfo("","SELECT * FROM mstcontacts ORDER BY display_order = '0',display_order asc");
		
		$rowcount = count($contactuslist);
		
		for($i=0;$i<$rowcount;$i++) {
		
				$contactusid 		= $contactuslist[$i]['contactusid'];
				$contactusadd1 	= $contactuslist[$i]['contactusadd1'];
				$contactusadd2 	= $contactuslist[$i]['contactusadd2'];
				$contactusadd3 	= $contactuslist[$i]['contactusadd3'];
				$contactuscity 	= $contactuslist[$i]['contactuscity'];
				$contactuspincode = $contactuslist[$i]['contactuspincode'];
				$contactusstate 	= $contactuslist[$i]['contactusstate'];
				$contactuscountry = $contactuslist[$i]['contactuscountry'];
				$contactustelno 	= $contactuslist[$i]['contactustelno'];
				$contactusfaxno 	= $contactuslist[$i]['contactusfaxno'];
				$contactusemail 	= $contactuslist[$i]['contactusemail'];
				$contactuswebsite = $contactuslist[$i]['contactuswebsite'];
				$contactustitle 	= $contactuslist[$i]['contactus_title'];
				$displayorder 		= $contactuslist[$i]['display_order'];
				
				
				
			
			$retun_contacts .=	'<div class="info-inner">
											<div class="info-container blacksmall contact-info"><h5>'.$contactustitle.' </h5></div>
											<div class="info-container blacksmall contact-info">'.$contactusadd1.' </div>
											<div class="info-container blacksmall contact-info">'.$contactusadd2.' </div>
											<div class="info-container blacksmall contact-info">Tel: '.$contactustelno.' </div>
											<div class="info-container blacksmall contact-info">Fax: '.$contactusfaxno.' </div>
											<div class="info-container blacksmall contact-info">Email: '.$contactusemail.' </div>
										</div></br>';
		
		
		}
		return $retun_contacts;	
	}	
	function getPagesListForCombo($GPageID=0)
	{
		
				$testclass		=	new AllTables();
				$pageslist 	=	$testclass->getInfo('', "SELECT * from mstpages order by pageid");
				
				$rowcount = count($pageslist);
				
				$strpageslist = "";

				if ($rowcount > 0)
				{
					//$currentpages = strtolower(rtrim(ltrim($Gpages)));
					$compare = 1;
					for($i=0;$i<$rowcount;$i++) 	
					{	
						/*
						if ($currentpages!='')
						{
							$databasepages = strtolower(rtrim(ltrim($pageslist[$i]['pagename'])));
							$compare = strcmp($currentpages,$databasepages);
						}
						else */
						
						if ($GPageID > 0)
						{
							$databasepages = intval($pageslist[$i]['pageid']);
							if ($databasepages==$GPageID)
							{
								$compare = 0;
							}
							else
							{
								$compare = 1;
							}

						}
						if ($compare == 0)
						{
							$strpageslist .= "<option value='".$pageslist[$i]['pageid']."' selected='selected'>".ucwords(strtolower($pageslist[$i]['pagename']))."</option>";
						}
						else
						{	
							$strpageslist .= "<option value='".$pageslist[$i]['pageid']."'>".ucwords(strtolower($pageslist[$i]['pagename']))."</option>";
						}
					}
				}
				unset($testclass);
				return $strpageslist;	
	}
	
function PageLeftSideEvents()
{
	$newsevents1 = new AllTables();
	$sql="select * from mstnewsevents WHERE CURDATE() < newsenddate and isEvent <> '0' order by newsenddate limit 0,2";
	//echo $sql;
	$newseventslist = $newsevents1-> getInfo('',$sql);
	
	if ($newseventslist)
	{
			$eventRowCount  = count($newseventslist);
			
			$eventExhibitions = '';
			for ($i=0;$i< $eventRowCount;$i++)
			{
				
				$eventLink = DOC_ROOT.'eventdetails/'.$newseventslist[$i]['newsid'].'.htm';
				//echo $eventLink;
				$imageThumb = ($newseventslist[$i]['newsimagethumb']!='')?'thumb/'.$newseventslist[$i]['newsimagethumb']:'coming_soon_img.jpg';
				$eventTitleForHomePage = preview_text($newseventslist[$i]['newstitle'],30);
				$eventDateFromTo = formatdate($newseventslist[$i]['newsdate'],'d').' - '.formatdate($newseventslist[$i]['newsenddate'],'d M Y'); 
				$eventVenue  = $newseventslist[$i]['eventVenue'];
				$eventCity = $newseventslist[$i]['eventCity'];
				$eventCountry  = $newseventslist[$i]['eventCountry'];
				
				$eventExhibitions .= '	<div class="col-md-12 col-xs-12" style="padding:5px; border-bottom:1px dotted #a9a9a9 ">
            								<div class="col-md-3 col-xs-3 p0">
												<a href='.$eventLink.' target="_new">            								
            								<img src="'.IMAGE_DIR.$imageThumb.'" class="img-responsive" alt="" /></a></div>
                							<div class="col-md-9 col-xs-9"><a href='.$eventLink.' target="_new"><b>'.$eventTitleForHomePage.'</b></a>'.$eventTitle.'<br />
												<span style="color:#333">'.$eventVenue.'</span><br />
												<a href='.$eventLink.' target="_new"><span style="color:#333">'.$eventDateFromTo.'</span></a></div>
            							</div>';
            	
			}
			return $eventExhibitions;
	}		
	
}

function linkstest()
{
	$newsevents1 = new AllTables();
	$sql="select * from mstnewsevents WHERE CURDATE() < newsenddate and isEvent <> '0' order by newsenddate limit 0,2";
	//echo $sql;
	$newseventslist = $newsevents1-> getInfo('',$sql);
	
	if ($newseventslist)
	{
			$eventRowCount  = count($newseventslist);
			
			$eventExhibitions = '';
			for ($i=0;$i< $eventRowCount;$i++)
			{
				
				$eventLink = DOC_ROOT.'eventdetails/'.$newseventslist[$i]['newsid'].'.htm';
				//echo $eventLink;
				$imageThumb = ($newseventslist[$i]['newsimagethumb']!='')?'thumb/'.$newseventslist[$i]['newsimagethumb']:'coming_soon_img.jpg';
				$eventTitleForHomePage = preview_text($newseventslist[$i]['newstitle'],30);
				$eventDateFromTo = formatdate($newseventslist[$i]['newsdate'],'d').' - '.formatdate($newseventslist[$i]['newsenddate'],'d M Y'); 
				$eventVenue  = $newseventslist[$i]['eventVenue'];
				$eventCity = $newseventslist[$i]['eventCity'];
				$eventCountry  = $newseventslist[$i]['eventCountry'];
				
				$eventExhibitions .= '	<div class="col-md-12 col-xs-12" style="padding:5px; border-bottom:1px dotted #a9a9a9 ">
            								<div class="col-md-3 col-xs-3 p0">
												<a href='.$eventLink.' target="_new">            								
            								<img src="'.IMAGE_DIR.$imageThumb.'" class="img-responsive" alt="" /></a></div>
                							<div class="col-md-9 col-xs-9"><a href='.$eventLink.' target="_new"><b>'.$eventTitleForHomePage.'</b></a>'.$eventTitle.'<br />
												<span style="color:#333">'.$eventVenue.'</span><br />
												<a href='.$eventLink.' target="_new"><span style="color:#333">'.$eventDateFromTo.'</span></a></div>
            							</div>';
            	
			}
			return $eventExhibitions;
	}		
	
}

function PageLeftSideNew()
{
		
	$news1 = new AllTables();
	
	$curdate = date('Y-m-d');
	$sql ="select * from mstnewsevents WHERE newsenddate >= '$curdate' and isEvent = '0' order by newsenddate asc";
	//echo $sql;
	$newslist = $news1-> getInfo('',"select * from mstnewsevents WHERE newsenddate >= '$curdate' and isEvent = '0' order by newsenddate asc");
	
	if ($newslist)
	{
			$newsRowCount  = count($newslist);
			
			
			for ($i=0;$i< $newsRowCount;$i++)
			{
				if($newslist[$i]['ishighlight']== 1) {
				$link_style = 'style="color:#0000ff"';
				}
				else {
				$link_style = 'style="color:#224974"';	
				} 
				$newslink = DOC_ROOT.'eventdetails/'.$newslist[$i]['newsid'].'.htm';
			
				$homeNews .= '<li><a href="'.$newslink.'"><h5 '.$link_style.'>'.preview_text($newslist[$i]['newstitle'],40).'</h5></a></li>';
			}
			return $homeNews;	
	}	
}
function ibtexnews()
{
		
	$news1 = new AllTables();
	
	$curdate = date('Y-m-d');
	$sql = "select * from mstcirculars where msttypeid='5' order by circulardate desc limit 0,3";	
	//echo $sql;
	$newslist = $news1-> getInfo('',$sql);
	
	if ($newslist)
	{
			$newsRowCount  = count($newslist);
			
			$ibtexNews ='';
			for ($i=0;$i< $newsRowCount;$i++)
			{
				
				$link_style = 'style="color:#224974"';	
				
				$newslink = DOC_ROOT.'ibtexnewsclipping/'.$newslist[$i]['circularfilepath'];
				//$newsdate = formatdate($newslist[$i]['circulardate'],'d M Y');
				$ibtexNews .= '<li><a href="'.$newslink.'" target="_new"><span '.$link_style.'>'.preview_text($newslist[$i]['circularname'],40).'</span></a> </li>';
			}
			return $ibtexNews;	
	}	
}
function getstatistics() 
{
	$news1 = new AllTables();
	
	$curdate = date('Y-m-d');
	$sql = "select * from mstcirculars where msttypeid='11' order by circulardate desc limit 0,3";	
	//echo $sql;
	$newslist = $news1-> getInfo('',$sql);
	
	if ($newslist)
	{
			$newsRowCount  = count($newslist);
			
			
			for ($i=0;$i< $newsRowCount;$i++)
			{
				
				$link_style = 'style="color:#224974"';	
				
				$newslink = DOC_ROOT.'statistics/'.$newslist[$i]['circularfilepath'];
				
				$homeNews .= '<li><a href="'.$newslink.'" target="_new"><span '.$link_style.'>'.preview_text($newslist[$i]['circularname'],40).'</span></a></li>';
			}
			return $homeNews;	
	}
}
function annualgeneralmeeting() 
{
	$news1 = new AllTables();
	
	$curdate = date('Y-m-d');
	$sql = "select * from mstcirculars where msttypeid='12' order by circulardate desc limit 0,3";	
	//echo $sql;
	$newslist = $news1-> getInfo('',$sql);
	
	if ($newslist)
	{
			$newsRowCount  = count($newslist);
			
			
			for ($i=0;$i< $newsRowCount;$i++)
			{
				
				$link_style = 'style="color:#224974"';	
				
				$newslink = DOC_ROOT.'agm/'.$newslist[$i]['circularfilepath'];
				
				$homeNews .= '<li><a href="'.$newslink.'" target="_new"><span '.$link_style.'>'.preview_text($newslist[$i]['circularname'],40).'</span></a></li>';
			}
			return $homeNews;	
	}
}
function powerpointpresentation() 
{
	$news1 = new AllTables();
	
	$curdate = date('Y-m-d');
	$sql = "select * from mstcirculars where msttypeid='13' order by circulardate desc limit 0,3";	
	//echo $sql;
	$newslist = $news1-> getInfo('',$sql);
	
	if ($newslist)
	{
			$newsRowCount  = count($newslist);
			
			
			for ($i=0;$i< $newsRowCount;$i++)
			{
				
				$link_style = 'style="color:#224974"';	
				
				$newslink = DOC_ROOT.'ppt/'.$newslist[$i]['circularfilepath'];
				
				$homeNews .= '<li><a href="'.$newslink.'" target="_new"><span '.$link_style.'>'.preview_text($newslist[$i]['circularname'],75).'</span></a></li>';
			}
			return $homeNews;	
	}
}	
function getScrolling_Govt_logos()
{
	$news1 = new AllTables();
	
	$curdate = date('Y-m-d');
	$sql ="SELECT * FROM `mstlogoimages` order by photoorder";
	//echo $sql;
	$newslist = $news1-> getInfo('',$sql);
	
	if ($newslist)
	{
			$newsRowCount  = count($newslist);
			$logos = 'var picData = [';		
			
			for ($i=0;$i< $newsRowCount;$i++)
			{
				$websitelink = ($newslist[$i]['imagewebsite']>'')?$newslist[$i]['imagewebsite']:'#';
				if ($i>0)
				{	
					$logos .= ",{ image:'".IMAGE_DIR."gallery/thumb/".$newslist[$i]['photoimagebig']."',title:'',link:'".$websitelink."',class:'img-responsive'}";
				}
				else 
				{	
					$logos .= "{ image:'".IMAGE_DIR."gallery/thumb/".$newslist[$i]['photoimagebig']."',title:'',link:'".$websitelink."',class:'img-responsive'}";
				}
			}
			$logos .= "]";
	}
	return $logos;
}	


function getHomePageVisitorFeedback() 
		{
			$testclass = new AllTables();
			
		
			$sql = 'SELECT a.exhibitionid, b.visitor_feedbackid, b.feedback_visitor, b.visitorname ,b.country_visitor FROM mstexhibition a INNER JOIN feedback_visitor b ON a.exhibitionid = b.exhibitionid ORDER BY a.exhibitionid DESC , b.visitor_feedbackid ASC';			
			
			
						
			$sliderimages = $testclass -> getInfo('',$sql);
			$rowcount = count($sliderimages);
			//print_r($sliderimages);
			for($i=0;$i<$rowcount;$i++) 
			{
			$visitor_feedbackid 			= 	$sliderimages[$i]['visitor_feedbackid'];
			$exhibitionid 			=	$sliderimages[$i]['exhibitionid'];
			$visitorname 		= 	$sliderimages[$i]['visitorname'];
			$feedback_visitor 			=	$sliderimages[$i]['feedback_visitor']; 
			$country_visitor 			=	$sliderimages[$i]['country_visitor']; 
	
			$activeclass ='';
			if ($i==0)
			{
				$activeclass = "active";
			}
				
				$slider_array .= ' <div class="item '.$activeclass.'">
       								
										 <div class="col-md-8 col-md-offset-2 visitor-speak text-center">
										<h4>'.$feedback_visitor.'</h4>
										 <p>'.$visitorname.'</p>
										  <p>'.$country_visitor.'</p>
										 </div>
      								</div>';
									
									
			
			
			}
	// <p >'.$phototitle.'</p>  //// name of banner image
			//print_r($slider_array);
			return $slider_array;
			
			
			
		}



function getExhibitionList()
	{
					$footer			=	new AllTables();
					$footersql		=	"Select * from mstexhibition ";
					$pagenamelist	=	$footer->getInfo('',$footersql);
					
							$pagecount		=	count($pagenamelist);
							for($i=0;$i<$pagecount;$i++)
							{
									$exhibitionid				=		$pagenamelist[$i]['exhibitionid'];
									$exhibitionname			=		ProperCase(trim($pagenamelist[$i]['exhibitiontitle']));
									$exhibitionlink			=		$exhibitionname;	
							      $link					=		DOC_ROOT.'exhibition-'.$exhibitionlink.'-'.$exhibitionid.'.htm';
									$subMenu				.=		'<li><a href="'.$link.'">'.$exhibitionname.'</a></li>';
							}
							return $subMenu;
				
		}
		
		function getExhibitionListForSeminar()
	{
					$footer			=	new AllTables();
					$footersql		=	"Select * from mstexhibition ";
					$pagenamelist	=	$footer->getInfo('',$footersql);
					
							$pagecount		=	count($pagenamelist);
							for($i=0;$i<$pagecount;$i++)
							{
									$exhibitionid				=		$pagenamelist[$i]['exhibitionid'];
									$exhibitionname			=		ProperCase(trim($pagenamelist[$i]['exhibitiontitle']));
									$exhibitionlink			=		toAscii($exhibitionname);	
							      $link					=		DOC_ROOT.'seminar-'.$exhibitionlink.'-'.$exhibitionid.'.htm';
									$subMenu				.=		'<li><a href="'.$link.'">'.$exhibitionname.'</a></li>';
							}
							return $subMenu;
				
		}
		
		function getExhibitionListForPastEvents()
	{
					$footer			=	new AllTables();
					$footersql		=	"Select * from mstexhibition ";
					$pagenamelist	=	$footer->getInfo('',$footersql);
					
							$pagecount		=	count($pagenamelist);
							for($i=0;$i<$pagecount;$i++)
							{
									$exhibitionid				=		$pagenamelist[$i]['exhibitionid'];
									$exhibitionname			=		ProperCase(trim($pagenamelist[$i]['exhibitiontitle']));
									$exhibitionlink			=		toAscii($exhibitionname);	
							      $link					=		DOC_ROOT.'event-'.$exhibitionlink.'-'.$exhibitionid.'.htm';
									$subMenu				.=		'<li><a href="'.$link.'">'.$exhibitionname.'</a></li>';
							}
							return $subMenu;
				
		}
		
		function getExhibitionListForBtoB()
	{
					$footer			=	new AllTables();
					$footersql		=	"Select * from mstexhibition ";
					$pagenamelist	=	$footer->getInfo('',$footersql);
					
							$pagecount		=	count($pagenamelist);
							for($i=0;$i<$pagecount;$i++)
							{
									$exhibitionid				=		$pagenamelist[$i]['exhibitionid'];
									$exhibitionname			=		ProperCase(trim($pagenamelist[$i]['exhibitiontitle']));
									$exhibitionlink			=		toAscii($exhibitionname);	
							      $link					=		DOC_ROOT.'photo-'.$exhibitionlink.'-'.$exhibitionid.'.htm';
									$subMenu				.=		'<li><a href="'.$link.'">'.$exhibitionname.'</a></li>';
							}
							return $subMenu;
				
		}
		
    function asidenavmenu(){
        $menu = "";
        
        $menulist = [
                        "Dashboard" => [
                            "iconClass" => "feather icon-home",
                            "link" => ["Home" => "index.php"]     
                        ],
                        
                        "Pages Setting" => [
                            "iconClass" => "feather icon-sidebar",
                            "link" => ["View Pages" => "view-page.php"]
                        ]
                    ];
        
        $menu .= '<nav class="pcoded-navbar">
                    <div class="pcoded-inner-navbar main-menu">
                    <div class="pcoded-navigatio-lavel">Dashboard123</div>
                    <ul class="pcoded-item pcoded-left-item">';
                    
                    foreach($menulist as $key => $value){   
                        $menu .= '<li class="pcoded-hasmenu active">
                                    <a href="javascript:void(0)">
                                    <span class="pcoded-micon"><i class="'.$value['iconClass'].'"></i></span>
                                    <span class="pcoded-mtext">'.$key.'</span>
                                    </a>';
                            if(is_array($value['link'])){
                                $menu .= '<ul class="pcoded-submenu">';
                                    foreach($value['link'] as $key1 => $value1){
                                        $menu .= '<li class="">
                                                <a href="'.$value1.'">
                                                <span class="pcoded-mtext">'.$key1.'</span>
                                                </a>
                                                </li>';
                                    }
                                $menu .= '</ul>';
                            }else{
                                
                            }
                        $menu .= '</li>';
                    }
        $menu .= '</div></div></ul></nav>';
        echo $menu;
    }
	
    function getParentMenu(){
        $alltable = new AllTables();
        
        $menusql = "select * from mstpages where isparentpage = 1 and parentpageid = 0 and status = 1 order by pageid ASC";
        $data = $alltable->getInfo('', $menusql);
        $count = count($data);
        
        $nav = "";
        $nav .= '<ul class="navbar-nav ml-auto" data-gumshoe>';
        if($count > 0){
            for($i=0;$i<$count;$i++){
                $pagetitle = $data[$i]['pagetitle'];//strtoupper($data[$i]['pagetitle']);
                $pageurl = $data[$i]['pageurl'];
                $pageid = $data[$i]['pageid'];
                
                $haschildmenu = hasChildMenu($pageid);
                
                if($haschildmenu){
                    $nav .= '<li class="nav-item has-submenu" id="m'.$i.'"><a class="nav-link" href="'.$pageurl.'.html">'.$pagetitle.'</a>';
                    
                    $childmenu = getChildMenu($pageid);
                    
                    $nav .= $childmenu;
                    $nav .= '</li>';
                }else{
                    $nav .= '<li><a href="'.$pageurl.'.html">'.$pagetitle.'</a></li>';    
                }
                
            }
        }
        $nav .= '</ul>';
        
        echo $nav;
    }
    
    function hasChildMenu($parentpageid){
        if($parentpageid != '' && $parentpageid != 0 && $parentpageid != null){
            $alltable = new AllTables();
        
            $menusql = "select * from mstpages where isparentpage = 0 and parentpageid = $parentpageid and status = 1 order by pageid ASC";
            $data = $alltable->getInfo('', $menusql);
            $count = count($data);
            
            if($count > 0){
                return true;
            }else{
                return false;
            }
        }
    }

    function getChildMenu($parentpageid = ""){
        if($parentpageid != '' && $parentpageid != 0){
            $alltable = new AllTables();
        
            $menusql = "select * from mstpages where isparentpage = 0 and parentpageid = $parentpageid and status = 1 order by pageid ASC";
            $data = $alltable->getInfo('', $menusql);
            $count = count($data);
            
            $nav = "";
            $nav .= '<ul class="ulsub"><li><ul>';
            if($count > 0){
                for($i=0;$i<$count;$i++){
                    $pagetitle = $data[$i]['pagetitle']; //strtoupper($data[$i]['pagetitle']);
                    $pageurl = $data[$i]['pageurl'];

                    $nav .= '<li><a href="'.$pageurl.'.html">'.$pagetitle.'</a></li>';
                }
            }
            $nav .= '</ul></li></ul>';
            
            return $nav;
        }
    }

    function getPageTitle($url){
        $alltable = new AllTables();
    
        $pageurl =  $url;
    
        $sql = "select * from ".PAGE_TABLE." where pageurl = '".$pageurl."' and status = 1 limit 0,1";
        $data = $alltable->getInfo('', $sql);
        if($data > 0){
            $pagetitle = $data[$i]['pagetitle']; //strtoupper($data[0]['pagetitle']);
        }
        
        echo $pagetitle;
    }
    
    function getSelectComboParentPage($pageid=""){
        $alltable = new AllTables();
        
        $menusql = "select * from mstpages where isparentpage = 1 and parentpageid = 0 and  status = 1 order by pageid ASC";
        $data = $alltable->getInfo('', $menusql);
        $count = count($data);
        
        $matchpageid = $pageid;
        $option = "";
        
        $option .= "<option value=''>Select Parent Page</option>";
        if($count > 0){
            for($i=0;$i<$count;$i++){
                
                $pagetitle = strtoupper($data[$i]['pagetitle']);
                $pageurl = $data[$i]['pageurl'];
                $pageids = $data[$i]['pageid'];
                
                if($matchpageid == $pageids){
                    $option .= "<option value='".$pageids."' selected>".$pagetitle."</option>";
                }else{
                    $option .= "<option value='".$pageids."'>".$pagetitle."</option>";
                }
            }
        }
        
        return $option;
    }

    function AllParentPageCount(){
        $alltable = new AllTables();
        
        $menusql = "select * from mstpages where isparentpage = 1 and parentpageid = 0 and status = 1 order by pageid ASC";
        $data = $alltable->getInfo('', $menusql);
        $count = count($data);
        
        return $count;
    }

    function AllChildPageCount(){
        $alltable = new AllTables();
        
        $menusql = "select * from mstpages where isparentpage = 0 and parentpageid != 0 and status = 1 order by pageid ASC";
        $data = $alltable->getInfo('', $menusql);
        $count = count($data);
        
        return $count;
    }
?>
